program FldrDiff;

{$APPTYPE CONSOLE}

{-$DEFINE DEBUG}

uses SysUtils, Classes, StrU, MD5_d4;

var Path, Files: TStringList;
    OldDir, NewDir, OutDir: String;
    OldFiles, NewFiles: TStringList;

type TChecksum = class
       Value: MD5Digest;
     end;  

     

const FileAttrs = faReadOnly or faArchive or faSysFile or faHidden;
      FolderAttrs = FileAttrs or faDirectory;


//------------------------------------------------------------------------------
function IsFolder(const Target: String): Boolean;
var s: TSearchRec;
    t: String;
    temp: TStringList;
begin
  temp:= TStringList.Create;
  t:= WinBkSlashes(Target);
  if t[Length(t)] = '\' then t:= Copy(t, 1, Length(t) - 1);
  SplitString(t, '\', temp);
  with temp do Result:=
    (IndexOf('.') = -1)
    and (IndexOf('..') = -1)
    and (AnsiPos('*', t) = 0) and (AnsiPos('?', t) = 0)
    and (FindFirst(t, FolderAttrs, s) = 0) and (s.Attr and faDirectory = faDirectory);
  temp.Free;
end;
//------------------------------------------------------------------------------
procedure MakeFolders(const What: String);
var L: TStrings;
    S, Pth: String;
    i: Integer;
begin
  if What <> EmptyStr then begin
    L:= TStringList.Create;
    SplitString(What, '\', L);
    DeleteEmptyStrings(L);
    Pth:= EmptyStr;
    with L do if Count > 0 then for i:= 0 to Count - 1 do begin
      S:= Strings[i];
      Pth:= Pth + S + '\';
      if not IsFolder(Pth) then
        MkDir(Pth); 
    end;
    L.Free;
  end;
end;
//------------------------------------------------------------------------------
procedure CopyFile(const Old, New: String);
var Src, Target: TFileStream;
begin
  Src:= TFileStream.Create(Old, fmOpenRead);
  MakeFolders(ExtractFilePath(New));
  Target:= TFileStream.Create(New, fmCreate);
  Target.CopyFrom(Src, Src.Size);
  Target.Free;
  Src.Free;
end;
//------------------------------------------------------------------------------
procedure FillFilesList(const RootSpec: String);
var Sr: TSearchRec;
    S: String;
    L: Integer;
begin
  if IsFolder(JoinStrings(Path, '\', True) + RootSpec) then begin
    Path.Add(WinBkSlashes(RootSpec));
    L:= Length(Path[0]) + 2; // + 1 as index starts at 1 ; +1 for \ ...
    S:= JoinStrings(Path, '\', True) + '*';
    if FindFirst(S, FolderAttrs, Sr) = 0 then repeat
      if (Sr.Attr and faDirectory = faDirectory) then FillFilesList(Sr.Name) else begin
        S:= JoinStrings(Path, '\', True) + Sr.Name;
        S:= System.Copy(S, L, MaxInt); // ... here. MaxInt - copy all to the end
        Files.Add(S);
        // so add to Files without first folder
      end;
    until FindNext(Sr) <> 0;
    FindClose(Sr);
    with Path do Delete(Count - 1); // remove last item
  end;
end;
//------------------------------------------------------------------------------
procedure DoOldCrc32s;
var i: Integer;
    T: TChecksum;
begin
  with OldFiles do if Count > 0 then for i:= 0 to Count - 1 do begin
    T:= TChecksum.Create;
    T.Value:= MD5File(OldDir + Strings[i]);
    Objects[i]:= T;
  end;
end;
//------------------------------------------------------------------------------
procedure DoNewCrc32s;
var i: Integer;
    T: TChecksum;
begin
  with NewFiles do if Count > 0 then for i:= 0 to Count - 1 do begin
    T:= TChecksum.Create;
    T.Value:= MD5File(NewDir + Strings[i]);
    Objects[i]:= T;
  end;
end;
//------------------------------------------------------------------------------
procedure CompareLists;
var i, CurIndex: Integer;
    OldChecksum, NewChecksum: MD5Digest;
    T: TChecksum;
    DeleteBat: TextFile;
    CurName: String;
begin
  AssignFile(DeleteBat, OutDir + 'FldrDiffUpdateDelete.bat');
  MakeFolders(OutDir);
  Rewrite(DeleteBat);
  Writeln(DeleteBat, 'rem This is an autogenerated script for updating created by FldrDiff.');
  with OldFiles do if Count > 0 then for i:= 0 to Count - 1 do begin
    CurName:= Strings[i];
    CurIndex:= NewFiles.IndexOf(CurName);
    if CurIndex = -1 then begin
      Writeln(DeleteBat, 'del ', CurName);
      // this file is not in the new folder, so add it to delete list
    end else begin
      T:= Objects[i] as TChecksum;
      OldChecksum:= T.Value;
      T:= NewFiles.Objects[CurIndex] as TChecksum;
      NewChecksum:= T.Value;
      T.Free;
      NewFiles.Delete(CurIndex);
      if not MD5Match(NewChecksum, OldChecksum) then
        CopyFile(NewDir + CurName, OutDir + CurName);
    end;
  end;
  CloseFile(DeleteBat);
  // now all old files are processed and their counterparts deleted from list,
  // BUT the ones that are brand new stayed
  with NewFiles do if Count > 0 then for i:= 0 to Count - 1 do begin
    CurName:= Strings[i];
    CopyFile(NewDir + CurName, OutDir + CurName);
    T:= Objects[i] as TChecksum;
    T.Free;
  end;
  NewFiles.Clear;
  // so do as said
  with OldFiles do if Count > 0 then for i:= 0 to Count - 1 do begin
    T:= Objects[i] as TChecksum;
    T.Free;
  end;
  OldFiles.Clear;
  // just remove leftovers
end;
//------------------------------------------------------------------------------


begin
  Writeln('FldrDiff, tool to compare two folders and sort out the changed files.');
  if ParamCount < 3 then begin
    Writeln('Syntax: FldrDiff OLD NEW OUT');
    Writeln('where OLD is the old folder, NEW is the new folder, and OUT is the folder with');
    Writeln('comparison result.');
    // help messages
  end else begin
    Files:= TStringList.Create;
    Path:= TStringList.Create;
    OldFiles:= TStringList.Create;
    NewFiles:= TStringList.Create;
    NewFiles.CaseSensitive:= False;
    // allocate objects 
    OldDir:= ParamStr(1) + '\';
    NewDir:= ParamStr(2) + '\';
    OutDir:= ParamStr(3) + '\';
    Writeln('Old: ', OldDir);
    Writeln('New: ', NewDir);
    Writeln('Out: ', OutDir);
    // resolve parameters
    Write('Listing files in old folder ... ');
    FillFilesList(OldDir);
    Writeln('done.');
    OldFiles.Assign(Files);
    // find all files from old
    Path.Clear;
    Files.Clear;
    // clear for new search
    Write('Listing files in new folder ... ');
    FillFilesList(NewDir);
    Writeln('done.');
    NewFiles.Assign(Files);
    // find all files from new
    Files.Free;
    Path.Free;
    // get rid of unnecessary objects
    {$IFDEF DEBUG}
    OldFiles.SaveToFile('old.txt');
    NewFiles.SaveToFile('new.txt');
    {$ENDIF}
    // debug
    Write('Calculating checksums for old folder ... ');
    DoOldCrc32s;
    Writeln('done.');
    Write('Calculating checksums for new folder ... ');
    DoNewCrc32s;
    Writeln('done.');
    // fill CRC32 info
    Write('Processing ... ');
    CompareLists;
    Writeln('done.');
    // do the work
    OldFiles.Free;
    NewFiles.Free;
  end;
  {$IFDEF DEBUG}
  Readln;
  {$ENDIF}
end.
