unit PoU;

interface

uses Classes;

type TTranslationItem = class
       constructor Create;
       destructor Destroy; override;
     private
       FComments: TStrings;
       FReferences: TStrings;
       FAutoComments: TStrings;
       FFuzzy, FC_Format, FNo_C_Format: Boolean;
       FMsgId, FMsgStr: String;
       FLineIndex: Integer;
     public
       property Fuzzy: Boolean read FFuzzy write FFuzzy;
       property C_Format: Boolean read FC_Format write FC_Format;
       property No_C_Format: Boolean read FNo_C_Format write FNo_C_Format;
       property Comments: TStrings read FComments;
       property References: TStrings read FReferences;
       property AutoComments: TStrings read FAutoComments write FAutoComments;
       property MsgId: String read FMsgId write FMsgId;
       property MsgStr: String read FMsgStr write FMsgStr;
       property LineIndex: Integer read FLineIndex write FLineIndex;
     end;

procedure ParseTranslationFromStrings(const Source: TStrings;
  const Target: TList; const Deferred: TStrings); 


//==============================================================================
implementation

uses SysUtils;
//==============================================================================

constructor TTranslationItem.Create;
begin
  FComments:=  TStringList.Create;
  FReferences:= TStringList.Create;
  FAutoComments:= TStringList.Create;
  FFuzzy:= False;
  FC_Format:= False;
  FNo_C_Format:= False;
end;

//------------------------------------------------------------------------------

destructor TTranslationItem.Destroy;
begin
  FComments.Free;
  FReferences.Free;
  FAutoComments.Free;
end;

//------------------------------------------------------------------------------

procedure ParseTranslationFromStrings(const Source: TStrings;
  const Target: TList; const Deferred: TStrings); 
var T: TTranslationItem;
    i: Integer;
    S, M: String;
    CommentsLoaded: Boolean;
    StartLineNum: Integer;
begin
  CommentsLoaded:= False;
  with Source do if Count > 0 then begin
    Deferred.Clear;
    i:= 0;
    T:= TTranslationItem.Create;
    StartLineNum:= 0;
    while i < Count do begin
      S:= Strings[i];
      if length(S) > 0 then case S[1] of
        '#': begin
          if CommentsLoaded then begin
            T.MsgStr:= M; 
            T.LineIndex:= StartLineNum;
            StartLineNum:= i + 1;
            Target.Add(T);
            T:= TTranslationItem.Create;
            CommentsLoaded:= False;
          end;
          if Length(S) > 1 then case S[2] of
            ':': T.References.Add(Copy(S, 4, Length(S) - 3));
            '.': T.AutoComments.Add(Copy(S, 4, Length(S) - 3));
            ' ': T.Comments.Add(Copy(S, 3, Length(S) - 2));
            '~': Deferred.Add(S);
            ',': begin
              S:= TrimRight(UpperCase(S));
              if S = '#, FUZZY' then T.Fuzzy:= True;
              if S = '#, C-FORMAT' then T.C_Format:= True;
              if S = '#, NO-C-FORMAT' then T.No_C_Format:= True;
            end;
          end;
        end;
        'm', 'M': begin
          if UpperCase(Copy(S, 1, 7)) = 'MSGID "' then begin
            CommentsLoaded:= True;
            M:= Copy(S, 8, Length(S) - 8); // - 7 (msgid ") - 1 (")
          end;  
          if UpperCase(Copy(S, 1, 8)) = 'MSGSTR "' then begin
            T.MsgId:= M;
            M:= Copy(S, 9, Length(S) - 9); // - 8 (msgstr ") - 1 (")
          end;
        end;
        '"': begin
          M:= M + Copy(S, 2, Length(S) - 2); // - 1 (") - 1 (") 
        end;
      end;
      Inc(i);
    end;
    if T.MsgId <> EmptyStr then begin
      T.MsgStr:= M;
      Target.Add(T);
    end else T.Free;
  end;
end;

end.
