(*************************************************************************
 *  TransGuiU.pas                                                        *
 *  Vladimr Slvik 2007                                                 *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  Routines for i18n - translating whole components trees.              *
 *                                                                       *
 *  -additional libraries: none                                          *
 *************************************************************************)
 
unit TransGuiU;

interface
//==============================================================================

uses Classes;

procedure TranslateComponent(const Target: TComponent);

procedure TranslateComponents(Target: array of TComponent);

{
  TranslateComponent checks for "Caption" and "Hint" since these are safe to
  look for. But there is additional bonus as well. It looks for

  ----------------------------------------------------------
  property OnTranslationRefresh: TnotifyEvent read SomeFunc;
  ----------------------------------------------------------

  and calls if it's present. This ellegantly bypasses need of having special
  objects and form subclasses and whatnot. Just write a handler manually and
  you'll catch retranslations - as simple as that. If you don't want, fine,
  no problem.

  The only gotcha is that this requires one *real* handler, one fake property
  and one reader function. Count 3 items more in declaration . Well, not a huge
  price after all. 
}

//==============================================================================
implementation

uses SysUtils, TypInfo,
     TranslationU;

//------------------------------------------------------------------------------

procedure TranslateComponent(const Target: TComponent);
var S: String;
    i: Integer;
    PropInfo: PPropInfo;
    N: TNotifyEvent;
begin
  if IsPublishedProp(Target, 'Caption') then begin
    S:= GetStrProp(Target, 'Caption');
    if S <> EmptyStr then
      SetStrProp(Target, 'Caption', Translate(S));
  end;
  // look for Caption
  if IsPublishedProp(Target, 'Hint') then begin
    S:= GetStrProp(Target, 'Hint');
    if S <> EmptyStr then
      SetStrProp(Target, 'Hint', Translate(S));
  end;
  // look for Hint
  PropInfo:= GetPropInfo(Target, 'OnTranslationRefresh', [tkMethod]);
  if Assigned(PropInfo) and
      (PropInfo^.PropType^.Kind = tkMethod) and
      (PropInfo^.PropType^.Name = 'TNotifyEvent') then begin
    // make damn hell sure it's what we want :D
    N:= TNotifyEvent(GetMethodProp(Target, 'OnTranslationRefresh'));
    // since this requires some "hard" typecasts
    if Assigned(N) then N(nil);
    // and finally call it ... if it is valid. paranoia.
    // returned data should not be probably freed ... undocumented feature :-/
  end;
  // look for callback
  with Target do if ComponentCount > 0 then for i:= 0 to ComponentCount - 1 do
    TranslateComponent(Components[i]);
    // look for children
end;

//------------------------------------------------------------------------------

procedure TranslateComponents(Target: array of TComponent);
var i: Integer;
begin
  if Length(Target) > 0 then for i:= Low(Target) to High(Target) do
    TranslateComponent(Target[i]);
end;

//------------------------------------------------------------------------------

end.
