(*************************************************************************
 *  ClChgU.pas + ClChgU.dfm                                              *
 *  Vladimr Slvik 2005-10                                              *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  dialog window for Shades :                                           *
 *    Show color and ask for overwrite; totally passive - no routines    *
 *    at all; handled by helper function.                                *
 *                                                                       *
 *  -additional libraries: none                                          *
 *************************************************************************)

unit ClChgU;

{$INCLUDE Switches.inc}
{t default -}

interface

uses
  Classes, Controls, Forms, ExtCtrls, StdCtrls, GR32;

type
  TClChgFrm = class(TForm)
    shpColor: TShape;
    Label1: TLabel;
    lblColor: TLabel;
    Label3: TLabel;
    Button1: TButton;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ClChgFrm: TClChgFrm;

function AskChangeColor(const Clr: TColor32; const Decimal: Boolean): Boolean;

//------------------------------------------------------------------------------

implementation

uses SysUtils, StrUtils,
     TranslationU, TransGuiU, ColorU,
     ConstStrU;

{$R *.dfm}

//------------------------------------------------------------------------------

procedure TClChgFrm.FormCreate(Sender: TObject);
begin
  TranslateComponent(Self);
  Font.Name:= Translate(sscFontName);
end;

//------------------------------------------------------------------------------

function AskChangeColor(const Clr: TColor32; const Decimal: Boolean): Boolean;
begin
  with ClChgFrm do begin
    shpColor.Brush.Color:= WinColor(Clr);
    lblColor.Caption:= IfThen(
      Decimal,
      Format(Translate('(%s)'), [Cl32ToDecPlain(Clr)]), //tf
      Format(Translate('$%s'), [Cl32ToHexPlain(Clr)]) ); //tf
    Result:= ShowModal = mrOk;
  end;
end;

//------------------------------------------------------------------------------

end.
