(*************************************************************************
 *  CoreTypeU.pas                                                        *
 *  Vladimr Slvik 2010                                                 *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  Core types and constants.                                            *
 *                                                                       *
 *  -additional libraries: Graphics32                                    *
 *************************************************************************)

unit CoreTypeU;

{$INCLUDE ..\Switches.inc}
{t default -}

interface

uses Classes, Graphics,
     GR32, GR32_Blend,
     OptionU, ConstStrU, ConfigU;

//------------------------------------------------------------------------------

const pmUndefined = 0; pmPencil = 1; pmFloodFill = 2; pmPxEraser = 3;
      pmFillEraser = 4;

type TPaintMode = pmUndefined .. pmFillEraser;

//------------------------------------------------------------------------------

const vmUndefined = -1; vmNormal = 0; vmDark = 1; vmHighlight = 2;

type TViewMode = vmUndefined .. vmHighlight;

//------------------------------------------------------------------------------

const PlayerColorPickerAliasPri = $FF0000FF;
      PlayerColorPickerAliasSec = $FF00FF00;
      ScaDarkStart = 1;
      ScaDarkEnd = 15;
      ScaPlayerPriStart = 16;
      ScaPlayerPriEnd = 23;
      ScaPlayerSecStart = 24;
      ScaPlayerSecEnd = 31;
      ScaAllStart = ScaDarkStart;
      ScaAllEnd = 32;

const SpecColorArray: array [1 .. 32] of record
        Normal, Special: TColor32;
        Description: String;
      end = (
       (Normal: $FF6B6B6B; Special: $FF6B6B6B;
         Description: sscScaNonDarkGrey), // #1
       (Normal: $FF9B9B9B; Special: $FF9B9B9B;
         Description: sscScaNonDarkGrey),
       (Normal: $FFB3B3B3; Special: $FFB3B3B3;
         Description: sscScaNonDarkGrey),
       (Normal: $FFC9C9C9; Special: $FFC9C9C9;
         Description: sscScaNonDarkGrey),
       (Normal: $FFDFDFDF; Special: $FFDFDFDF;
         Description: sscScaNonDarkGrey), // #5
       // first 5 non-darkening
       (Normal: $FF57656F; Special: $FFD6C384;
         Description: sscScaDarkWindowsLitNight), // #6
       (Normal: $FF7F9BF1; Special: $FF84C3D6;
         Description: sscScaLightBlueLight),
       (Normal: $FFFFFF53; Special: $FFFFFF52;
         Description: sscScaYellowLight),
       (Normal: $FFFF211D; Special: $FFFF2018;
         Description: sscScaRedLight),
       (Normal: $FF01DD01; Special: $FF00DF00;
         Description: sscScaGreenLight),
       (Normal: $FFE3E3FF; Special: $FFFFFFE7;
         Description: sscScaColdWhiteLight),
       (Normal: $FFC1B1D1; Special: $FFD6C384;
         Description: sscScaBlueWndLitNight),
       (Normal: $FF4D4D4D; Special: $FFD6C384;
         Description: sscScaDarkWindowsLitNight),
       (Normal: $FFFF017F; Special: $FFFF017F;
         Description: sscScaPurpleLight),
       (Normal: $FF0101FF; Special: $FF0101FF;
         Description: sscScaDarkBlueLight), // #15
       // the 10 shiny (glowing)
       (Normal: $FF244B67; Special: PlayerColorPickerAliasPri;
         Description: sscScaPriPlayerClr), // #23
       (Normal: $FF395E7C; Special: PlayerColorPickerAliasPri;
         Description: sscScaPriPlayerClr), // #16
       (Normal: $FF4C7191; Special: PlayerColorPickerAliasPri;
         Description: sscScaPriPlayerClr),
       (Normal: $FF6084A7; Special: PlayerColorPickerAliasPri;
         Description: sscScaPriPlayerClr),
       (Normal: $FF7497BD; Special: PlayerColorPickerAliasPri;
         Description: sscScaPriPlayerClr),
       (Normal: $FF88ABD3; Special: PlayerColorPickerAliasPri;
         Description: sscScaPriPlayerClr),
       (Normal: $FF9CBEE9; Special: PlayerColorPickerAliasPri;
         Description: sscScaPriPlayerClr),
       (Normal: $FFB0D2FF; Special: PlayerColorPickerAliasPri;
         Description: sscScaPriPlayerClr),
       // player primary
       (Normal: $FF7B5803; Special: PlayerColorPickerAliasSec;
         Description: sscScaSecPlayerClr), // #24
       (Normal: $FF8E6F04; Special: PlayerColorPickerAliasSec;
         Description: sscScaSecPlayerClr),
       (Normal: $FFA18605; Special: PlayerColorPickerAliasSec;
         Description: sscScaSecPlayerClr),
       (Normal: $FFB49D07; Special: PlayerColorPickerAliasSec;
         Description: sscScaSecPlayerClr),
       (Normal: $FFC6B408; Special: PlayerColorPickerAliasSec;
         Description: sscScaSecPlayerClr),
       (Normal: $FFD9CB0A; Special: PlayerColorPickerAliasSec;
         Description: sscScaSecPlayerClr),
       (Normal: $FFECE20B; Special: PlayerColorPickerAliasSec;
         Description: sscScaSecPlayerClr),
       (Normal: $FFFFF90D; Special: PlayerColorPickerAliasSec;
         Description: sscScaSecPlayerClr), // #31
       // player secondary
       (Normal: $00E7FFFF; Special: $FFE7FFFF;
         Description: sscScaTransparentBackground) // #32
       // transparent
       ); // constant for color selector

//------------------------------------------------------------------------------

const BackClrOpaque = $FFE7FFFF;
      BackClrTransparent = $00E7FFFF;

//==============================================================================

implementation

//------------------------------------------------------------------------------

end.

