(*************************************************************************
 *  ToolBkFixU.pas                                                       *
 *  Vladimr Slvik 2009-10                                              *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  Tool for fixing background colour.                                   *
 *                                                                       *
 *  -additional libraries: Graphics32                                    *
 *************************************************************************)

unit ToolBkFixU;

{$INCLUDE ..\Switches.inc}
{t default -}

//------------------------------------------------------------------------------

interface

uses ClassBaseU, GR32;

//------------------------------------------------------------------------------

type TFixBkTool = class(TStaticToolBase)
     public
       DecimalColors: Boolean;
       procedure Act; override;
     end; 

//==============================================================================
implementation

uses Windows, Forms, StrUtils, SysUtils, TranslationU,
     CoreTypeU, CoreLowU, CoreEngineU, CalcUtilU, ClChgU, ConstStrU;
//==============================================================================

procedure TFixBkTool.Act;
var B: TBitmap32;
    R: TRect;
    Clr: TColor32;
begin
  Clr:= FEngine.Picture.PixelS[0,0];
  if IsBackgroundColor(Clr) then begin
    Application.MessageBox(PChar(IfThen(
      FEngine.Options.InterfaceOptions.DecimalIndicator,
      Translate(sscAlreadyBackColorDec),
      Translate(sscAlreadyBackColorHex))), // both too long for direct literal
    PChar(Translate(sscMsgCapInfo)), MB_OK + MB_ICONINFORMATION);
  end else if AskChangeColor(Clr, DecimalColors) then begin
    FEngine.CopyOverlay;
    B:= FEngine.Overlay;
    ReplaceColor(B, Clr, BackClrOpaque, B.BoundsRect);
    R:= B.BoundsRect;
    FEngine.CommitOverlay(R);
    FEngine.RedrawRect(R);
  end;
end;

//------------------------------------------------------------------------------

end.
