(*************************************************************************
 *  ToolFillU.pas                                                        *
 *  Vladimr Slvik 2009-10                                              *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  Tool for "bucket fill" or "floodfill".                               *
 *                                                                       *
 *  -additional libraries: Graphics32                                    *
 *************************************************************************)

unit ToolFillU;

{$INCLUDE ..\Switches.inc}
{t default -}

//------------------------------------------------------------------------------

interface

uses Classes, ClassBaseU, GR32, Controls;

//------------------------------------------------------------------------------

type TFillTool = class(TClickToolBase)
     public
       procedure MouseDown(const Button: TMouseButton; const X, Y: Integer;
         const Shift: TShiftState); override;
     end;

//==============================================================================
implementation

uses CoreLowU, SysUtils, CoreEngineU, CalcUtilU;
//==============================================================================

procedure TFillTool.MouseDown(const Button: TMouseButton; const X, Y: Integer;
  const Shift: TShiftState);
var ActionPlace: TRect;
begin
  if Button = mbLeft then with FEngine do begin
    CopyOverlay;
    FloodFill32(Overlay, Point(X, Y), ToolOptions.Color, ActionPlace,
      ToolOptions.DiagonalFill);
    CommitOverlay(ActionPlace);
    RedrawRect(ActionPlace);
  end;
end;

//------------------------------------------------------------------------------

end.
