program Recolorer;

{$APPTYPE GUI}

//------------------------------------------------------------------------------

uses
  Windows,
  SysUtils,
  Classes,
  Graphics,
  GR32,
  PNGImage,
  Math,
  StrU,
  ColorU,
  Contnrs,
  RecolorU in '..\..\RecolorU.pas';

//------------------------------------------------------------------------------

const MaxResults = 48;

//------------------------------------------------------------------------------

function MessageBox(HWnd: Integer; Text, Caption: PChar; Flags: Integer): Integer;
  stdcall; external 'user32.dll' name 'MessageBoxA';

//------------------------------------------------------------------------------

procedure Load(const FileName: String; const Picture: TBitmap32);
var P: TPNGObject;
begin
  P:= TPNGObject.Create;
  P.LoadFromFile(FileName);
  Picture.Assign(P);
  P.Free;
end;

//------------------------------------------------------------------------------

procedure Save(const FileName: String; const Picture: TBitmap32);
var P: TPNGObject;
    B: TBitmap;
begin
  P:= TPNGObject.Create;
  B:= TBitmap.Create;
  B.Assign(Picture);
  P.Assign(B);
  P.SaveToFile(FileName);
  B.Free;
  P.Free;
end;

//------------------------------------------------------------------------------

var Kernels: TObjectList;

procedure ClearKernels;
var i: Integer;
    K: TMatchKernelBase;
begin
  with Kernels do if Count > 0 then for i:= Count - 1 downto 0 do begin
    K:= Kernels[i] as TMatchKernelBase;
    K.Free;
    Kernels.Delete(i);
  end;
end;

procedure LoadOptions(const FileName: String);
var Line: TStrings;
    Inputs: TStrings;
    i: Integer;
    Kernel: TMatchKernelBase;
begin
  ClearKernels;
  Line:= TStringList.Create;
  Inputs:= TStringList.Create;
  Inputs.LoadFromFile(FileName);
  for i:= 0 to Inputs.Count - 1 do begin
    SplitString(Inputs[i], ' ', Line);
    if Line.Count > 1 then begin
      if Line[0] = 'background' then begin
        Kernel:= TBackgroundKernel.Create(Line);
        Assert(Assigned(Kernel));
        Kernels.Add(TObject(Kernel));
      end else if Line[0] = 'gray' then begin
        Kernel:= TGrayKernel.Create(Line);
        Assert(Assigned(Kernel));
        Kernels.Add(TObject(Kernel));
      end else if Line[0] = 'point' then begin
        Kernel:= TPointKernel.Create(Line);
        Assert(Assigned(Kernel));
        Kernels.Add(TObject(Kernel));
      end else if Line[0] = 'ball' then begin
        Kernel:= TBallKernel.Create(Line);
        Assert(Assigned(Kernel));
        Kernels.Add(TObject(Kernel));
      end else if Line[0] = 'keep' then begin
        Kernel:= TKeepKernel.Create(Line);
        Assert(Assigned(Kernel));
        Kernels.Add(TObject(Kernel));
      end;
    end;
  end;
  Inputs.Free;
  Line.Free;
end;

//------------------------------------------------------------------------------

var Results: array [0 .. MaxResults] of TTransformResult;

procedure ProcessPicture(const FileName: String);
var Picture: TBitmap32;
    x,y,i: Integer;
    BestIndex: Integer;
begin
  Picture:= TBitmap32.Create;
  Load(FileName, Picture);
  Results[MaxResults].Distance:= Infinity;
  for x:= 0 to Picture.Width - 1 do for y:= 0 to Picture.Height - 1 do begin
    BestIndex:= MaxResults;
    for i:= 0 to Kernels.Count - 1 do begin
      Assert(Kernels.Items[i] is TMatchKernelBase);
      Results[i]:= (Kernels.Items[i] as TMatchKernelBase).Transform(Picture.Pixel[x,y]);
      if Results[i].Valid and (Results[i].Distance < Results[BestIndex].Distance) then
        BestIndex:= i;
    end;
    Picture.Pixel[x,y]:= Results[BestIndex].Value;
  end;
  Save(FileName, Picture);
  Picture.Free;
end;

//------------------------------------------------------------------------------

var i: Integer;
    ImageFile, ConfigFile: String;

begin
  if ParamCount < 1 then begin
    MessageBox(0, 'Just drop files on my icon. Read the sample  options.cfg  file for hints on configuration.',
      'Usage', MB_OK + MB_ICONINFORMATION);
  end else begin
    Kernels:= TObjectList.Create(False);
    for i:= 1 to ParamCount do begin
      ImageFile:= ParamStr(i);
      ConfigFile:= ExtractFilePath(ImageFile) + 'options.cfg';
      LoadOptions(ConfigFile);
      ProcessPicture(ImageFile);
    end;
    ClearKernels;
    Kernels.Free;
  end;
end.                                  
