﻿#!/bin/env python
"""
Script for extracting string base from Shades code.
"""

# Vladimír Slávik 2007
# utf-8

import re, os, glob;

translation = {};
index = [];

class Entry :
	def __init__(self) :
		self.references = [];
		self.isFormat = False;

def Escape (OldString) :
	return OldString.replace(r'"', r'\"').replace("\n", "\\n");

text = re.compile(r"'([^']+)'");
# finding 'string'
mark = re.compile(r"//t([+-f]+)");
# finding //t????? flags
defmark = re.compile(r"{t default ([+-f])}");
# finding {t default ?} directives

os.chdir("..");
units = glob.glob("*.pas") + glob.glob("ToolsU/*.pas") + glob.glob("CoreU/*.pas") + glob.glob("Components/*.pas");
for unit in units :
	default = '-';
	i = 0;
	input = open(unit, 'r');
	lines = input.readlines();
	input.close();
	while i < len(lines) :
		line = lines[i];
		texts = text.findall(line);
		flags = mark.findall(line);
		defaults = defmark.findall(line);
		if len(defaults) == 1 :
			default = defaults[0];
			# must be one string, and brackets extract exactly one char with directive "value"
			# !!!! affects the whole line on which is found - also backward!
		if (len(texts) >= 1) and ((len(flags) == 1) or (default != '-')) :
			# texts must be present, and flags as well
			for j in range(0, len(texts)) :
				item = texts[j];
				if len(item) > 0 :
					S = Escape(item); ##item.replace(r'"', r'\"');
					if (j < 0) or (len(flags) < 1) :
						flag = default;
					elif j < len(flags) :
						flag = flags[0][j];
					else :
						flag = flags[0][-1];
					# j-th or last flag
					if flag != '-' :
						if not translation.has_key(S) :
							translation[S] = Entry();
							index.append(S);
						# add the string entry if needed
						translation[S].references.append(unit + ":" + str(i + 1));
						# add reference to it
						if flag == 'f' :
							translation[S].isFormat = True;
		i = i + 1;

forms = glob.glob("*.dfm");
caption = re.compile(r"Caption = '.+'");
hint = re.compile(r"Hint = '.+'");
dummy = re.compile(r"%dummy_.+");
for form in forms :
	input = open(form, 'r');
	lines = input.readlines();
	input.close();
	i = 0;
	while i < len(lines) :
		line = lines[i];
		hintFound = hint.search(line);
		captionFound = caption.search(line);
		dummyFound = dummy.search(line);
		if ((captionFound != None) or (hintFound != None)) and (dummyFound == None) :
			add = text.search(line);
			S = add.group()[1:-1];
			S = Escape(S); ##S.replace(r'"', r'\"');
			if len(add.group()) > 2 :
				if not translation.has_key(S) :
					translation[S] = Entry();
					index.append(S);
				translation[S].references.append(form + ":" + str(i + 1));
		i = i + 1;

os.chdir("resources");

input = open("Thanks.txt", 'r');
lines = input.readlines();
input.close();
i = 0;
while i < len(lines) :
	line = lines[i];
	S = Escape(line.replace("\n", '')); ## 
	if len(S) > 0 :
		if S[0] != '*' :
			if not translation.has_key(S) :
				translation[S] = Entry();
				index.append(S);
			translation[S].references.append("resources/Thanks.txt:" + str(i + 1));
	i = i + 1;

input = open("About.txt", 'r');
lines = input.readlines();
input.close();
if lines[-1] == '' :
    del lines[-1];
i = 0;
while i < len(lines) :
	line = lines[i];
	S = Escape(line.replace("\n", '')); ## 
	if len(S) > 0 :
		if not translation.has_key(S) :
			translation[S] = Entry();
			index.append(S);
		translation[S].references.append("resources/About.txt:" + str(i + 1));
	i = i + 1;

os.chdir("..");
output = open(os.path.join("translations", "shades.pot"), 'w');
output.write('msgid ""\nmsgstr ""\n"Project-Id-Version: Shades\\n"\n"MIME-Version: 1.0\\n"\n"Content-Type: text/plain; charset=UTF-8\\n"\n"Content-Transfer-Encoding: 8bit\\n"\n');
for item in index :
	for loc in translation[item].references :
		output.write("#: " + loc + "\n");
	if translation[item].isFormat :
		output.write("#, object-pascal-format\n");
	output.write('msgid "' + item + '"\nmsgstr ""\n\n');
output.close();


