(*************************************************************************
 *  ConvertU.pas                                                         *
 *  Vladimr Slvik 2007                                                 *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  Core part of UpConvert - database of routines that know how to       *
 *    lift settings from old versions                                    *
 *                                                                       *
 *  -additional libraries: none                                          *
 *************************************************************************)

unit ConvertU;

{$I ../../Switches.inc}

//------------------------------------------------------------------------------
interface

//------------------------------------------------------------------------------
// stuff for easy finding the needed proc

type TConvertProc = procedure(const A,B: String); register;

function FindConversion(const AFrom, ATo: String): TConvertProc;

//------------------------------------------------------------------------------
// procs that do the actual conversion

procedure Up40to50(const AFrom, ATo: String); register;

//==============================================================================
implementation

uses Windows, SysUtils, Classes, IniFiles, StrU, FileU;
//------------------------------------------------------------------------------

function FindConversion(const AFrom, ATo: String): TConvertProc;
var Temp: TConvertProc;
begin
  Temp:= nil;
  try
    if (AFrom = '4.0') and (ATo = '5.0') then begin
      Temp:= Up40to50;
      Abort;
    end;
    // and so on...
  except
    Result:= Temp;
  end;
end;

//------------------------------------------------------------------------------

procedure Up40to50(const AFrom, ATo: String);
var Files, L: TStrings;
    Old, New: String;
    i: Integer;
    F: TIniFile;
begin
  Files:= TStringList.Create;
  try
    FindFilesByMask(GoodSlashes(AFrom + '/*.png'), Files);
    // find the stuff
    MkDir(GoodSlashes(ATo));
    MkDir(GoodSlashes(ATo + '/Backgrounds'));
    with Files do if Count > 0 then for i:= 0 to Count - 1 do begin
      Old:= GoodSlashes(AFrom + '/' + Strings[i]);
      New:= GoodSlashes(ATo + '/Backgrounds/' + Strings[i]);
      if not CopyFile(PChar(Old), PChar(New), True) then
        raise Exception.Create('Already exists...'); //t-
    end;
    // copy background files
    Old:= GoodSlashes(AFrom + '/Options.dat');
    New:= GoodSlashes(ATo + '/Options.ini');
    CopyFile(PChar(Old), PChar(New), False);
    F:= TIniFile.Create(GoodSlashes(ATo + '/Options.ini'));
    L:= TStringList.Create;
    F.ReadSectionValues('BackgroundPictures', L);
    StringsReplace(L, AFrom, GoodSlashes(ATo + '/Backgrounds'));
    // fix 4.0 -> 5.0
    L.Insert(0, '[BackgroundPictures]');
    L.SaveToFile(GoodSlashes(ATo + '/Backgrounds.ini'));
    F.EraseSection('BackgroundPictures');
    F.UpdateFile;
    F.Free;
  finally
    Files.Free;
  end;
end;

//------------------------------------------------------------------------------


end.
