unit ConsoleU;

interface

uses Windows, SysUtils;

const DefaultTextAndBackgroundAttributes: Word = 7;

function GetConsoleInputHandle: THandle;
function GetConsoleOutputHandle: THandle;
function GetConsoleErrorHandle: THandle;
function GetMaxX: Word;
function GetMaxY: Word;
function GetCurX: Word;
function GetCurY: Word;
procedure GoToXY(X, Y: Word);
procedure WriteTextXY(X, Y: Word; sText: String);
procedure WriteTextXYAndReturn(X, Y: Word; sText: String);
procedure ClearScreen;
procedure ShowCursor;
procedure HideCursor;
function GetCursorSize: Word;
procedure SetCursorSize(newSize: Word);
procedure SetCaption(sCaption: String);
function GetCaption: String;
procedure SetBoolBackgroundColor
  (Red, Green, Blue, Intensity: Boolean);
procedure SetBoolTextColor
  (Red, Green, Blue, Intensity: Boolean);
procedure SetDefaultColors;


//==============================================================================
implementation

function GetConsoleInputHandle: THandle;
begin
  Result:=GetStdHandle(STD_INPUT_HANDLE);
end;

//------------------------------------------------------------------------------

function GetConsoleOutputHandle: THandle;
begin
  Result:=GetStdHandle(STD_OUTPUT_HANDLE);
end;

//------------------------------------------------------------------------------

function GetConsoleErrorHandle: THandle;
begin
  Result:=GetStdHandle(STD_ERROR_HANDLE);
end;

//------------------------------------------------------------------------------

function GetMaxX: Word;
var c: COORD;
begin
  c:=GetLargestConsoleWindowSize(GetConsoleOutputHandle);
  Result:=c.X;
end;

//------------------------------------------------------------------------------

function GetMaxY: Word;
var c: COORD;
begin
  c:=GetLargestConsoleWindowSize(GetConsoleOutputHandle);
  Result:=c.Y;
end;

//------------------------------------------------------------------------------

function GetCurX: Word;
var csbi: _CONSOLE_SCREEN_BUFFER_INFO;
begin
  GetConsoleScreenBufferInfo(GetConsoleOutputHandle, csbi);
  Result:=csbi.dwCursorPosition.X;
end;

//------------------------------------------------------------------------------

function GetCurY: Word;
var csbi: _CONSOLE_SCREEN_BUFFER_INFO;
begin
  GetConsoleScreenBufferInfo(GetConsoleOutputHandle, csbi);
  Result:=csbi.dwCursorPosition.Y;
end;

//------------------------------------------------------------------------------

procedure GoToXY(X, Y: Word);
var c: COORD;
begin
  c.X:=X;
  c.Y:=Y;
  SetConsoleCursorPosition(GetConsoleOutputHandle, c)
end;

//------------------------------------------------------------------------------

procedure WriteTextXY(X, Y: Word; sText: String);
var c: Cardinal;
begin
  GoToXY(X, Y);
  WriteConsole(GetConsoleOutputHandle, PChar(sText),
               Length(sText), C, nil);
end;

//------------------------------------------------------------------------------

procedure WriteTextXYAndReturn(X, Y: Word; sText: String);
var curX, curY: Word;
begin
  curX:=GetCurX;
  curY:=GetCurY;
  WriteTextXY(X, Y, sText);
  GoToXY(curX, curY);
end;

//------------------------------------------------------------------------------

procedure ClearScreen;
var c: COORD;
    r: DWORD;
begin
  c.X:=0;
  c.Y:=0;
  FillConsoleOutputCharacter(GetConsoleOutputHandle, ' ',
  GetMaxX*GetMaxY, c, r);
end;

//------------------------------------------------------------------------------

procedure ShowCursor;
var cci: CONSOLE_CURSOR_INFO;
begin
  GetConsoleCursorInfo(GetConsoleOutputHandle, cci);
  cci.bVisible:=True;
  SetConsoleCursorInfo(GetConsoleOutputHandle, cci);
end;

//------------------------------------------------------------------------------

procedure HideCursor;
var cci: CONSOLE_CURSOR_INFO;
begin
  GetConsoleCursorInfo(GetConsoleOutputHandle, cci);
  cci.bVisible:=False;
  SetConsoleCursorInfo(GetConsoleOutputHandle, cci);
end;

//------------------------------------------------------------------------------

function GetCursorSize: Word;
var cci: CONSOLE_CURSOR_INFO;
begin
  GetConsoleCursorInfo(GetConsoleOutputHandle, cci);
  Result:=cci.dwSize;
end;

//------------------------------------------------------------------------------

procedure SetCursorSize(newSize: Word);
var cci: CONSOLE_CURSOR_INFO;
begin
  GetConsoleCursorInfo(GetConsoleOutputHandle, cci);
  cci.dwSize:=newSize;
  SetConsoleCursorInfo(GetConsoleOutputHandle, cci);
end;

//------------------------------------------------------------------------------

procedure SetCaption(sCaption: String);
begin
  SetConsoleTitle(PChar(sCaption));
end;

//------------------------------------------------------------------------------

function GetCaption: String;
var pc: Array [0..255] Of Char;
begin
  GetConsoleTitle(pc, 255);
  Result:=pc;
end;

//------------------------------------------------------------------------------

procedure SetBoolBackgroundColor
  (Red, Green, Blue, Intensity: Boolean);
var attr: Word;
    csbi: CONSOLE_SCREEN_BUFFER_INFO;
begin
  GetConsoleScreenBufferInfo(GetConsoleOutputHandle, csbi);
  attr:=0;
  If((csbi.wAttributes AND FOREGROUND_RED)>0)
    Then attr:=attr OR FOREGROUND_RED;
  If((csbi.wAttributes AND FOREGROUND_GREEN)>0)
    Then attr:=attr OR FOREGROUND_GREEN;
  If((csbi.wAttributes AND FOREGROUND_BLUE)>0)
    Then attr:=attr OR FOREGROUND_BLUE;
  If((csbi.wAttributes AND FOREGROUND_INTENSITY)>0)
    Then attr:=attr OR FOREGROUND_INTENSITY;
  If(Red) Then attr:=attr OR BACKGROUND_RED;
  If(Green) Then attr:=attr OR BACKGROUND_GREEN;
  If(Blue) Then attr:=attr OR BACKGROUND_BLUE;
  If(Intensity) Then attr:=attr OR BACKGROUND_INTENSITY;
  SetConsoleTextAttribute(GetConsoleOutputHandle, attr);
end;

//------------------------------------------------------------------------------

procedure SetBoolTextColor
  (Red, Green, Blue, Intensity: Boolean);
var attr: Word;
    csbi: CONSOLE_SCREEN_BUFFER_INFO;
begin
  GetConsoleScreenBufferInfo(GetConsoleOutputHandle, csbi);
  attr:=0;
  If((csbi.wAttributes AND BACKGROUND_RED)>0)
    Then attr:=attr OR BACKGROUND_RED;
  If((csbi.wAttributes AND BACKGROUND_GREEN)>0)
    Then attr:=attr OR BACKGROUND_GREEN;
  If((csbi.wAttributes AND BACKGROUND_BLUE)>0)
    Then attr:=attr OR BACKGROUND_BLUE;
  If((csbi.wAttributes AND BACKGROUND_INTENSITY)>0)
    Then attr:=attr OR BACKGROUND_INTENSITY;
  If(Red) Then attr:=attr OR FOREGROUND_RED;
  If(Green) Then attr:=attr OR FOREGROUND_GREEN;
  If(Blue) Then attr:=attr OR FOREGROUND_BLUE;
  If(Intensity) Then attr:=attr OR FOREGROUND_INTENSITY;
  SetConsoleTextAttribute(GetConsoleOutputHandle, attr);
end;

//------------------------------------------------------------------------------

procedure SetDefaultColors;
begin
  SetConsoleTextAttribute(GetConsoleOutputHandle,
  DefaultTextAndBackgroundAttributes);
end;




end.
